/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.DoubleNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.DecimalPlacePanel;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.dialog.comp.MeasurementPanel;
import DE.siemens.ad.logo.dialog.comp.TimeInputPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.model.panel.PIDParameterset;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class PIDPanel
extends AbstractProtectionPanel {
    private MeasurementPanel fMeasurementPanel;
    private DecimalPlacePanel fDecimalPlacesPanel;
    private IntegerOrReferencePanel fSetPoint;
    private JComboBox fParamSet;
    private DoubleNumericSpinner fLoopGain;
    private TimeInputPanel fIntegralTime;
    private JRadioButton fUpButton;
    private JRadioButton fDownButton;
    private ButtonGroup fDirectionGroup;
    private JCheckBox fEnableTI;
    private IntegerOrReferencePanel fManualOutput;
    private JLabel fIntegralTimeLabel;
    private JLabel fLoopGainLabel;
    private JLabel fDirLabel;

    public PIDPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.initComponents();
    }

    private void initComponents() {
        JPanel parameterPanel = new JPanel(new GridBagLayout());
        this.addParameterPane(new JScrollPane(parameterPanel));
        this.fMeasurementPanel = new MeasurementPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        parameterPanel.add((Component)this.fMeasurementPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.gridwidth = 4;
        parameterPanel.add((Component)new JSeparator(), gbc);
        JPanel outputPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        parameterPanel.add((Component)outputPanel, gbc);
        this.fSetPoint = new IntegerOrReferencePanel();
        this.fSetPoint.setTitle(Language.getString("dialog.parameter.pid.sp", "Set point"));
        JPanel fSetPointPanel = new JPanel(new BorderLayout());
        fSetPointPanel.add(this.fSetPoint);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 0, 0, 0);
        outputPanel.add((Component)this.fSetPoint, gbc);
        this.fManualOutput = new IntegerOrReferencePanel();
        this.fManualOutput.setTitle(Language.getString("dialog.parameter.pid.mq", "Manual Output"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 0, 0, 0);
        outputPanel.add((Component)this.fManualOutput, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 1;
        gbc.gridwidth = 4;
        parameterPanel.add((Component)new JSeparator(), gbc);
        JPanel pidParameterPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        parameterPanel.add((Component)pidParameterPanel, gbc);
        JLabel lblParamSet = new JLabel(Language.getString("dialog.parameter.pid.paramSet", "Set"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        pidParameterPanel.add((Component)lblParamSet, gbc);
        this.fParamSet = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 20, 5, 5);
        pidParameterPanel.add((Component)this.fParamSet, gbc);
        this.fLoopGainLabel = new JLabel(Language.getString("dialog.parameter.pid.gain", "KC"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        pidParameterPanel.add((Component)this.fLoopGainLabel, gbc);
        this.fLoopGain = new DoubleNumericSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 20, 5, 5);
        pidParameterPanel.add((Component)this.fLoopGain, gbc);
        this.fEnableTI = new JCheckBox(Language.getString("dialog.parameter.pid.integral", "TI"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        pidParameterPanel.add((Component)this.fEnableTI, gbc);
        JPanel integralTimePanel = new JPanel(new FlowLayout(0));
        this.fIntegralTime = new TimeInputPanel();
        this.fIntegralTimeLabel = new JLabel();
        this.fIntegralTimeLabel.setAlignmentX(0.0f);
        integralTimePanel.add(this.fIntegralTime);
        integralTimePanel.add((Component)this.fIntegralTimeLabel, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 15, 5, 5);
        pidParameterPanel.add((Component)integralTimePanel, gbc);
        this.fDirLabel = new JLabel(Language.getString("dialog.parameter.pid.dir", "Dir"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        pidParameterPanel.add((Component)this.fDirLabel, gbc);
        this.fUpButton = new JRadioButton(Language.getString("dialog.parameter.pid.up", "+"), true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 15, 5, 0);
        pidParameterPanel.add((Component)this.fUpButton, gbc);
        this.fDownButton = new JRadioButton(Language.getString("dialog.parameter.pid.down", "-"));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        pidParameterPanel.add((Component)this.fDownButton, gbc);
        this.fDirectionGroup = new ButtonGroup();
        this.fDirectionGroup.add(this.fUpButton);
        this.fDirectionGroup.add(this.fDownButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 4;
        gbc.fill = 1;
        parameterPanel.add((Component)new JSeparator(), gbc);
        this.fDecimalPlacesPanel = new DecimalPlacePanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 16;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        parameterPanel.add((Component)this.fDecimalPlacesPanel, gbc);
        this.initListener();
    }

    private void initListener() {
        this.fParamSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PIDPanel.this.fParamSet.getSelectedIndex() == PIDParameterset.INDEX_USER_DEFINED_SET) {
                    PIDPanel.this.setEnablePIDParameter(true);
                    if (PIDPanel.this.fIntegralTime.getHighValue() == 99 && PIDPanel.this.fIntegralTime.getLowValue() == 59) {
                        PIDPanel.this.fEnableTI.setSelected(false);
                        PIDPanel.this.fIntegralTime.setEnabled(false);
                    } else {
                        PIDPanel.this.fEnableTI.setSelected(true);
                    }
                } else {
                    PIDPanel.this.setParameterset((PIDParameterset)PIDPanel.this.fParamSet.getSelectedItem());
                    PIDPanel.this.setEnablePIDParameter(false);
                }
            }
        });
        this.fEnableTI.addItemListener(new ItemListener(){
            private TimeUnit fOldIntegralTime;

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                PIDPanel.this.fIntegralTime.setEnabled(selected);
                if (!selected) {
                    this.fOldIntegralTime = new Minutes();
                    PIDPanel.this.fIntegralTime.storeFieldContents(this.fOldIntegralTime);
                    PIDPanel.this.fIntegralTime.setHighValue(99);
                    PIDPanel.this.fIntegralTime.setLowValue(59);
                } else {
                    PIDPanel.this.fIntegralTime.loadFieldContents(this.fOldIntegralTime);
                }
            }
        });
    }

    protected void setParameterset(PIDParameterset paramSet) {
        this.fLoopGain.setValue(paramSet.getLoopGain());
        this.fEnableTI.setSelected(paramSet.isIFunctionUsed());
        this.fIntegralTime.loadFieldContents(paramSet.getIntegralTime());
        boolean value = paramSet.getDirection() == '+';
        this.fUpButton.setSelected(value);
    }

    private void setEnablePIDParameter(boolean enableFlag) {
        this.fLoopGainLabel.setEnabled(enableFlag);
        this.fLoopGain.setEnabled(enableFlag);
        this.fEnableTI.setEnabled(enableFlag);
        this.fIntegralTime.setEnabled(enableFlag);
        this.fIntegralTimeLabel.setEnabled(enableFlag);
        this.fUpButton.setEnabled(enableFlag);
        this.fDownButton.setEnabled(enableFlag);
        this.fDirLabel.setEnabled(enableFlag);
    }

    public void setLabels() {
        super.setLabels();
        this.fMeasurementPanel.setLabels();
        this.fDecimalPlacesPanel.setLabels();
        TimeUnit value = ((PIDParameter)this.getParameterReference()).getIntegralTimer().getParamTime();
        String timeUnitName = Language.getString(value.getUnitKey(), value.getDefaultUnitString());
        this.fIntegralTimeLabel.setText(timeUnitName);
    }

    public boolean checkChanged() {
        if (this.fMeasurementPanel.checkChanged() || this.fSetPoint.checkChanged() || this.fManualOutput.checkChanged() || this.fParamSet.getSelectedIndex() != ((PIDParameter)this.fParameterReference).getParameterset() || this.fLoopGain.getValue() != ((PIDParameter)this.fParameterReference).getLoopGainProperties().getCurrentValue() || this.fIntegralTime.checkChanged(((PIDParameter)this.getParameterReference()).getIntegralTimer().getParamTime()) || this.directionChanged() || this.fDecimalPlacesPanel.checkChanged()) {
            return true;
        }
        return super.checkChanged();
    }

    private boolean directionChanged() {
        if (this.fUpButton.isSelected()) {
            return ((PIDParameter)this.fParameterReference).getDirection().charValue() == '-';
        }
        return ((PIDParameter)this.fParameterReference).getDirection().charValue() == '+';
    }

    public boolean checkFieldContents() {
        if (!(this.fSetPoint.checkValue(true) && this.fManualOutput.checkValue(true) && this.fLoopGain.checkValue(true) && this.fIntegralTime.checkFieldContents())) {
            return false;
        }
        return super.checkFieldContents();
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        PIDParameter param = (PIDParameter)this.fParameterReference;
        this.fMeasurementPanel.setModel(param.getMeasurement());
        try {
            this.fMeasurementPanel.loadFieldContents();
        }
        catch (ProgramException e) {
            e.printStackTrace();
        }
        Block thisBlock = param.getBlock();
        ArrayList blocksForReference = thisBlock.getWiringDiagram().getBlocksForReference(thisBlock, true);
        this.fSetPoint.setReferenceList(blocksForReference);
        this.fSetPoint.setProperties(((PIDParameter)this.fParameterReference).getSetpoint());
        this.fManualOutput.setReferenceList(blocksForReference);
        this.fManualOutput.setProperties(((PIDParameter)this.fParameterReference).getManualOutput());
        this.fLoopGain.setProperties(param.getLoopGainProperties());
        this.fIntegralTime.loadFieldContents(param.getIntegralTimer().getParamTime());
        this.fIntegralTime.setLowValueMinimum(1);
        this.fDecimalPlacesPanel.setAnalog(param);
        this.fDecimalPlacesPanel.loadFieldContents();
        if (param.getDirection().charValue() == '+') {
            this.fUpButton.setSelected(true);
        } else {
            this.fDownButton.setSelected(true);
        }
        this.fParamSet.setModel(new DefaultComboBoxModel<PIDParameterset>(PIDParameterset.getList()));
        this.fParamSet.setSelectedIndex(param.getParameterset());
        this.getRemanenceField().setEnabled(false);
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        this.fMeasurementPanel.storeFieldContents();
        this.fDecimalPlacesPanel.storeFieldContents();
        PIDParameter param = (PIDParameter)this.fParameterReference;
        param.setSetpoint(this.fSetPoint.getValue());
        param.setManualOutput(this.fManualOutput.getValue());
        param.setParameterset(this.fParamSet.getSelectedIndex());
        DoubleValueProperties loopGainProp = param.getLoopGainProperties();
        loopGainProp.setCurrentValue(this.fLoopGain.getValue());
        this.fIntegralTime.storeFieldContents(param.getIntegralTimer().getParamTime());
        if (this.fUpButton.isSelected()) {
            param.setDirection(Character.valueOf('+'));
        } else {
            param.setDirection(Character.valueOf('-'));
        }
    }
}

